<?php
header('Content-Type: application/json');

// Include the connection file
include 'connection.php';

// --- Get POST values ---
$user_id = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$categori_id = isset($_POST['categori_id']) ? intval($_POST['categori_id']) : 0;

// --- Check for data (status not null) ---
$sql = "SELECT * FROM enrollments 
        WHERE user_id = ? AND categori_id = ? AND status IS NULL 
        LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $user_id, $categori_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode([
        "status" => "success",
        "data" => $row
    ]);
} else {
    echo json_encode([
        "status" => "not_found"
    ]);
}

$stmt->close();
$conn->close();
?>
