<?php
header("Content-Type: application/json");

// Include database connection
include 'connection.php';

try {
    // Sanitize table input
    $table = isset($_POST['table']) ? $conn->real_escape_string($_POST['table']) : '';
    if (empty($table)) {
        http_response_code(400);
        echo json_encode([
            "status" => "error",
            "message" => "Table name is required"
        ]);
        exit();
    }

    // Optional WHERE condition
    $whereKey = isset($_POST['where_key']) ? $conn->real_escape_string($_POST['where_key']) : '';
    $whereValue = isset($_POST['where_value']) ? $conn->real_escape_string($_POST['where_value']) : '';

    // Build SQL query
    $sql = "SELECT * FROM `$table`";
    if (!empty($whereKey) && $whereValue !== '') {
        $sql .= " WHERE `$whereKey` = '$whereValue'";
    }

    $result = $conn->query($sql);
    $data = [];

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }
        echo json_encode([
            "status" => "success",
            "data" => $data
        ]);
    } else {
        echo json_encode([
            "status" => "success",
            "data" => [],
            "message" => "No records found"
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Server error occurred"
    ]);
} finally {
    $conn->close();
}
?>
