<?php
header("Content-Type: application/json");

// Include database connection
include 'connection.php';

// Get POST parameter
$chapter_id = isset($_POST['chapter_id']) ? intval($_POST['chapter_id']) : 0;

if ($chapter_id <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid or missing chapter_id"
    ]);
    exit();
}

// Use prepared statement for safety
$sql = "SELECT * FROM live_exams WHERE chapter_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $chapter_id);
$stmt->execute();
$result = $stmt->get_result();

$data = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        "status" => "success",
        "message" => "Data fetched successfully",
        "chapter_id" => $chapter_id,
        "data" => $data
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "No records found",
        "chapter_id" => $chapter_id
    ]);
}

$stmt->close();
$conn->close();
?>
