<?php
header("Content-Type: application/json");

// Include the database connection
include 'connection.php';

// Get POST parameters safely
$categori_id = isset($_POST['categori_id']) ? intval($_POST['categori_id']) : 0;
$date = isset($_POST['date']) ? trim($_POST['date']) : '';

if ($categori_id <= 0 || empty($date)) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid or missing parameters",
        "categori_id" => $categori_id,
        "date" => $date
    ]);
    exit();
}

// Use prepared statement for safety
$sql = "SELECT * FROM live_exams WHERE categori_id = ? AND date = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $categori_id, $date);
$stmt->execute();
$result = $stmt->get_result();

$data = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        "status" => "success",
        "message" => "Data fetched successfully",
        "categori_id" => $categori_id,
        "date" => $date,
        "data" => $data
    ]);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "No records found",
        "categori_id" => $categori_id,
        "date" => $date
    ]);
}

$stmt->close();
$conn->close();
?>
