<?php
header('Content-Type: application/json');

// Allow only POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode([
        'status' => 'error',
        'message' => 'Only POST requests are allowed.'
    ]);
    exit;
}

// Include the PDO connection
include 'connection.php';

try {
    // Get live_exam_id from POST (optional)
    $live_exam_id = $_POST['live_exam_id'] ?? null;

    // Build SQL query dynamically
    $sql = "SELECT * FROM rangkings";
    if (!empty($live_exam_id)) {
        $sql .= " WHERE live_exam_id = :live_exam_id";
    }
    $sql .= " ORDER BY CAST(marks AS UNSIGNED) DESC";

    $stmt = $pdo->prepare($sql);
    if (!empty($live_exam_id)) {
        $stmt->execute([':live_exam_id' => $live_exam_id]);
    } else {
        $stmt->execute();
    }

    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $rankedData = [];

    if (empty($results)) {
        echo json_encode([
            "status" => "error",
            "message" => "No records found."
        ]);
        exit;
    }

    // Start transaction for safety
    $pdo->beginTransaction();

    $position = 1;
    $updateStmt = $pdo->prepare("UPDATE rangkings SET position = :position WHERE id = :id");

    foreach ($results as $row) {
        $updateStmt->execute([
            ':position' => $position,
            ':id' => $row['id']
        ]);

        // Add position to output data
        $row['position'] = $position;
        $rankedData[] = $row;

        $position++;
    }

    $pdo->commit();

    echo json_encode([
        "status" => "success",
        "message" => "Positions updated successfully.",
        "total_updated" => count($rankedData),
        "data" => $rankedData
    ]);

} catch (PDOException $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
