<?php
header('Content-Type: application/json');

// Include the database connection
include 'connection.php';

// Get POST data safely
$categori_id = isset($_POST['id']) ? intval($_POST['id']) : 0;

if ($categori_id <= 0) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid or missing 'id' in POST request"
    ]);
    exit();
}

// Prepare and execute query safely
$sql = "SELECT * FROM images WHERE categori_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $categori_id);
$stmt->execute();
$result = $stmt->get_result();

$data = [];

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }

    echo json_encode([
        "status" => "success",
        "message" => "Images fetched successfully",
        "data" => $data
    ]);
} else {
    echo json_encode([
        "status" => "success",
        "message" => "No images found for this category",
        "data" => []
    ]);
}

$stmt->close();
$conn->close();
?>
