<?php
header("Content-Type: application/json");
include 'connection.php'; // include shared DB connection

function insertData($conn, $table, $data) {
    // --- Security: Allow only safe table names (letters, numbers, underscore)
    if (!preg_match('/^[a-zA-Z0-9_]+$/', $table)) {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid table name"
        ]);
        return;
    }

    // --- Prepare SQL
    $columns = implode(", ", array_keys($data));
    $placeholders = implode(", ", array_fill(0, count($data), '?'));
    $values = array_values($data);
    $types = str_repeat("s", count($values)); // assume all string types for simplicity

    $sql = "INSERT INTO `$table` ($columns) VALUES ($placeholders)";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo json_encode([
            "status" => "error",
            "message" => "Prepare failed: " . $conn->error
        ]);
        return;
    }

    // --- Bind and execute
    $stmt->bind_param($types, ...$values);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "Record inserted successfully",
            "insert_id" => $stmt->insert_id
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Insert failed: " . $stmt->error
        ]);
    }

    $stmt->close();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents("php://input"), true);

    if (isset($input['table']) && isset($input['data']) && is_array($input['data'])) {
        insertData($conn, $input['table'], $input['data']);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Invalid input format. Expecting {table: 'table_name', data: {...}}"
        ]);
    }
} else {
    http_response_code(405);
    echo json_encode([
        "status" => "error",
        "message" => "Only POST requests are allowed"
    ]);
}

$conn->close();
?>
